<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <title>Local Market Insight Report</title>
  <link type="text/css" rel="stylesheet" media="all" href="{$webroot}/css/LocalMarketInsightCover.css"/>
</head>
<body>
  <div id="page">

   <div id="header">
   </div><!-- end id="header" -->

   <div id="content">
      <div class="cover-date-background"><img src="{$webroot}/img/LMI_Cover_TopBanner.png" alt="Local Market Insight" wdith="540px" height="80px" /></div>
      <div class="cover-date">
        {if $agg_type=="QUARTERLY"}
            {$quarterLong} {$currYear} 
        {else}
            {$currMonthTimestamp|date_format:"%B %Y"}
        {/if}
      </div>
      <div class="cover-reportnames">
         {foreach from=$homeTypes item=homeType}
           {$homeType}<br>
         {/foreach}
      </div>
      <div class="cover-lmi-title"><img src="{$webroot}/img/LMI_Cover_Title.png" width="540px" height="80px" alt="Local Market Insight" /></div>
      <div class="cover-location">{$locationName}</div>
   </div><!-- end id="content" -->

   <div id="footer">
    <div id="footer-logo"><img src="{$webroot}/img/RBI_Logo.png" width="144px" alt="" /></div>
      {if not isset($personalizedData)}
          {if isset($show_logo_on_cover) && ($show_logo_on_cover)}
            <img src="{$webroot}/img/{$mls_logo}" class="mls_logo" width="109" alt="mls-logo" />
          {/if}
      {else}
        <div class="cover-personalized">
            <div class="cover-presented">Presented by</div>
            <div class="cover-name">{$personalizedData["first_name"]} {$personalizedData["last_name"]}</div>
            <div class="cover-agency">{$personalizedData["company_name_c"]}</div>
            <div class="cover-details">
                  {if $personalizedData["email1"]!=""}Email: {$personalizedData["email1"]}<br/>{/if}
                  {if $personalizedData["phone_work"]!=""}Work Phone: {$personalizedData["phone_work"]}<br/>{/if}
                  {if $personalizedData["phone_mobile"]!=""}Mobile Phone: {$personalizedData["phone_mobile"]}<br/>{/if}
                  {if $personalizedData["website_c"]!=""}Web: {$personalizedData["website_c"]}{/if}
            </div>
        </div><!-- end id="cover-personalized" -->
      {/if}
   </div><!-- end id="footer" -->

  </div><!-- end id="page" -->
</body>
</html>
