<?php
#if (!isset($resetcodes)) {
#    include_once('mris/boot.php');
#}
/* SugarCRM REST API */
/*
site_url   = "https://rbintel.sugarondemand.com"
username   = "Porter"
password   = "UtAgapNabOz9"
account_id = "d0a7391b-f845-21c8-1912-4c5c658f30de"
*/

$url        = "https://rbintel.sugarondemand.com/service/v2/rest.php";
$username   = "Porter";
$password   = "UtAgapNabOz9";
$account_id = "d0a7391b-f845-21c8-1912-4c5c658f30de";

//test
//$url = "http://localhost/sugarce/service/v2/rest.php";
//$username = 'tester';
//$password = 'tester';

//Login to SugarCRM site via apo
function sugar_login() {    
  global $url, $username, $password;
    $result = sugar_execute_command($url, 'login',
                  array('user_auth'=>array('user_name'=> $username, 'password'=>md5($password), 'version'=>'.01'), 
                              'application_name'=>'SoapTest',  
                              'name_value_list' => array(array('name' => 'notifyonsave', 'value' => 'false'))));
  if (isset($result->id)) { //set sugarCRM session id
      $_SESSION['SUGARCRM_SESSION_ID'] = $result->id;
      $_SESSION['sugar_user_obj'] = $result;
  }
  return $result;                               
}

function sugar_logout() {
  global $url;
  $result = sugar_execute_command($url, 'logout', array('user_auth' => array('session'=>$_SESSION['SUGARCRM_SESSION_ID'])));
}


function sugar_get_all_accounts() {
  global $url;
  $session = $_SESSION['SUGARCRM_SESSION_ID'];

  $params = array(
      'session' => $session, 
      'module_name' => 'Contacts', 
      'query' => ' assigned_user_name = "Tester"',
      'order_by' => ' contacts.last_name asc', 
      'offset' => 0, 
      'select_fields' => array('id', 'name', 'first_name', 'last_name', 'account_name', 'account_id', 'assigned_user_name', 'primary_address_city'),  
      'max_results' => 0, 
      'deleted' => false
  );    
  $result = sugar_execute_command($url, "get_entry_list", $params);
  return $result;
}

function sugar_delete_contact($id) {
  //set_entry(session,module_name, name_value_list)
    global $url;
  $session = $_SESSION['SUGARCRM_SESSION_ID'];
  $params = array(
      'session' => $session, 
      'module_name' => 'Contacts', 
        'name_value_list' => array(
                                                0 => array('name' => 'id', 'value' => $id),
                                                1 => array('name' => 'deleted', 'value' => 1)
                                            ),
  );    
  $result = sugar_execute_command($url, "set_entry", $params);
  return $result;   
}

function sugar_delete_product_by_id($id) {
  //set_entry(session,module_name, name_value_list)
    global $url;
  $session = $_SESSION['SUGARCRM_SESSION_ID'];
  $params = array(
      'session' => $session, 
      'module_name' => 'Products', 
        'name_value_list' => array(
                                                0 => array('name' => 'id', 'value' => $id),
                                                1 => array('name' => 'deleted', 'value' => 1)
                                            ),
  );    
  $result = sugar_execute_command($url, "set_entry", $params);
  return $result;   
}

function sugar_delete_products_by_contact_id($cid) {
  global $url;
  $session = $_SESSION['SUGARCRM_SESSION_ID'];

  $params = array(
      'session' => $session, 
      'module_name' => 'Products', 
      'query' => ' contact_id = "' . $cid . '"',
      'order_by' => ' products.id asc', 
      'offset' => 0, 
      'select_fields' => array('id', 'name', 'contact_id'),  
      'max_results' => 0, 
      'deleted' => false
  );    
  $result = sugar_execute_command($url, "get_entry_list", $params);
    if ($result->result_count) {
        $prods = array();
        foreach($result->entry_list as $entry) {
            $prods[] = array(
                                                0 => array('name' => 'id', 'value' => $entry->id),
                                                1 => array('name' => 'deleted', 'value' => 1)
                                            );
        }
        $params = array(
            'session' => $session, 
            'module_name' => 'Products', 
            'name_value_list' => $prods,
    );
    $result = sugar_execute_command($url, "set_entries", $params);
        return $result;
    }
  return $result;   
}

function make_name_value_list($values) {
    $retval = array();
    foreach($values as $key=>$value) {
        $retval[] = array('name' => $key, 'value' => $value,);
    }
    return $retval;
}

function sugar_put_contact($first_name, $last_name, $email, $account_id, $assigned_user_id) {
  global $url;
  $session = $_SESSION['SUGARCRM_SESSION_ID'];
  $params = array(
      'session' => $session, 
      'module_name' => 'Contacts', 
      'name_value_list' => array(
          0 => array(
              'name' => 'first_name',
              'value' => $first_name,
          ),
          1 => array(
              'name' => 'last_name',
              'value' => $last_name,
          ),
          2 => array(
              'name' => 'email1',
              'value' => $email,
          ),
          3 => array(
              'name' => 'account_id',
              'value' => $account_id,
          ),
          4 => array(
              'name' => 'assigned_user_id',
              'value' => $assigned_user_id,
          ),
      ),
  );
  $result = sugar_execute_command($url, "set_entry", $params);
  return $result;
}

function sugar_put_contact_expanded($name_value_list, $module='Contacts') {
    global $url;
  $session = $_SESSION['SUGARCRM_SESSION_ID'];
  $params = array(
      'session' => $session, 
      'module_name' => $module, 
      'name_value_list' => $name_value_list,
    );
  $result = sugar_execute_command($url, "set_entry", $params);
  return $result;
}

function sugar_get_item_lists($module_name, $module_fields = NULL, $query = '') {
    global $url;
    $result = sugar_execute_command($url, 'get_entry_list', 
                            array(
                                'session' => $_SESSION['SUGARCRM_SESSION_ID'],
                                'module_name' => $module_name,
                                'query' => $query,
                                'order_by' => 'name asc',
                                'offset' => 0,
                                'select_fields' => $module_fields,
                                'max_results' => 0, 
                                'deleted' => false
                            )
                        );
    return $result;
}

function sugar_get_contact($first_name, $last_name, $email) {
  global $url;
  $session = $_SESSION['SUGARCRM_SESSION_ID'];

  $params = array(
      'session' => $session, 
      'module_name' => 'Contacts', 
        'query' => sprintf('contacts.first_name = "%s" and contacts.last_name = "%s" and ' .
                             'contacts.id IN (SELECT eabr.bean_id FROM email_addr_bean_rel eabr ' .
                             'JOIN email_addresses ea ON eabr.email_address_id = ea.id ' .
                             'WHERE eabr.bean_module = "Contacts" AND ea.email_address = "%s")', $first_name, $last_name, $email),
      'order_by' => ' contacts.last_name asc', 
      'offset' => 0, 
      'select_fields' => array('id', 'first_name', 'last_name', 'email1', 'title', 'primary_address_street', 'primary_address_city',
                                'primary_address_state', 'primary_address_postalcode', 'primary_address_country',
                                //survey fields
                                'company_name_c', 'pref_county_c', 'mris_id_c', 'broker_code_c', 'gender_c', 'years_in_re_c', 
                                'nrds_id_c', 'lead_source', 'website_c', 'account_type_c', 'p_association_c', 'phone_mobile', 'phone_work', 'birthdate'), 
      'max_results' => 0, 
      'deleted' => false
  );
    
  $result = sugar_execute_command($url, "get_entry_list", $params);
  return $result;
}

function sugar_get_contact_by_id($id) {
  global $url;
  $session = $_SESSION['SUGARCRM_SESSION_ID'];

  $params = array(
      'session' => $session, 
      'module_name' => 'Contacts', 
        'query' => sprintf('contacts.id = "%s"', $id),
      'order_by' => ' contacts.last_name asc', 
      'offset' => 0, 
      'select_fields' => array('id', 'first_name', 'last_name', 'email1', 'title', 'primary_address_street', 'primary_address_city',
                                'primary_address_state', 'primary_address_postalcode', 'primary_address_country',
                                //survey fields
                                'company_name_c', 'pref_county_c', 'mris_id_c', 'broker_code_c', 'gender_c', 'years_in_re_c', 
                                'nrds_id_c', 'lead_source', 'website_c', 'account_type_c', 'p_association_c', 'phone_mobile', 'phone_work', 'birthdate'), 
      'max_results' => 0, 
      'deleted' => false
  );
    
  $result = sugar_execute_command($url, "get_entry_list", $params);
  return $result;
}

function sugar_get_lead($first_name, $last_name, $email) {
  global $url;
  $session = $_SESSION['SUGARCRM_SESSION_ID'];

  $params = array(
      'session' => $session, 
      'module_name' => 'Leads', 
        'query' => sprintf('leads.first_name = "%s" and leads.last_name = "%s" and ' .
                             'leads.id IN (SELECT eabr.bean_id FROM email_addr_bean_rel eabr ' .
                             'JOIN email_addresses ea ON eabr.email_address_id = ea.id ' .
                             'WHERE eabr.bean_module = "Leads" AND ea.email_address = "%s")', $first_name, $last_name, $email),
      'order_by' => ' leads.last_name asc', 
      'offset' => 0, 
      'select_fields' => array('id', 'first_name', 'last_name', 'email1', 'title', 'primary_address_street', 'primary_address_city',
                                'primary_address_state', 'primary_address_postalcode', 'primary_address_country',
                                //survey fields
                                'company_name_c', 'pref_county_c', 'mris_id_c', 'broker_code_c', 'gender_c', 'years_in_re_c', 
                                'nrds_id_c', 'lead_source', 'account_type_c', 'p_association_c', 'phone_mobile', 'phone_work', 'birthdate'), 
      'max_results' => 0, 
      'deleted' => false
  );
    
  $result = sugar_execute_command($url, "get_entry_list", $params);
  return $result;
}

function sugar_get_contact_by_email($email) {
  global $url;
  $session = $_SESSION['SUGARCRM_SESSION_ID'];

  $params = array(
      'session' => $session, 
      'module_name' => 'Contacts', 
        'query' => sprintf('contacts.id IN (SELECT eabr.bean_id FROM email_addr_bean_rel eabr ' .
                             'JOIN email_addresses ea ON eabr.email_address_id = ea.id ' .
                             'WHERE eabr.bean_module = "Contacts" AND ea.email_address = "%s")', $email),
      'order_by' => ' contacts.last_name asc', 
      'offset' => 0, 
      'select_fields' => array('id', 'name', 'first_name', 'last_name', 'account_name', 'email1'), 
      'max_results' => 0, 
      'deleted' => false
  );
    
  $result = sugar_execute_command($url, "get_entry_list", $params);
  return $result;
}


/*-------------------------------*/

//get_available_modules()
function sugar_get_available_modules() {
  global $url;
  $result = sugar_execute_command($url, 'get_available_modules', array('session' => $_SESSION['SUGARCRM_SESSION_ID']));
  return $result;
}

//get_module_fields()
function    sugar_get_module_fields($module_name, $params = NULL) {
  global $url;
    $session = $_SESSION['SUGARCRM_SESSION_ID'];
  $result = sugar_execute_command($url, 'get_module_fields', 
                      array('session' => $session,
                                  'module_name' => $module_name,
                                  'fields' => $params
                      ));
  return $result;
}


//get_entry()
function sugar_get_entry($session, $module_name, $id, $select_fields = NULL, $link_name_to_fields_array) {
  global $url;
  $result = sugar_execute_command($url, 'get_entry', 
                      array('session' => $_SESSION['SUGARCRM_SESSION_ID'],
                                  'module_name' => $module_name,
                                  'id' => $id,
                                  'select_fields' => $select_fields,
                                  'link_name_to_fields_array' => $link_name_to_fields_array, 
                      ));
}

function getContacts($session, $query='',$maxnum=0,$orderby=' contacts.last_name asc'){
  global $url;
    $result = sugar_execute_command($url, 'get_entry_list', 
                                array('session' => $session, 
                                            'module_name' => 'Contacts', 
                                            'query' => $query, 
                                            'order_by' => $orderby, 
                                            'offset' => 0, 
                                            'select_fields' => array('id', 'first_name', 'last_name', 'account_name', 'account_id', 'email1', 'phone_work'),  
                                            'max_results' => $maxnum, 
                                            'deleted' => false));
    return $result;
} 

function getUsers($session, $query='',$maxnum=0,$orderby=' contacts.last_name asc'){
  global $url;
    $result = sugar_execute_command($url, 'get_entry_list', 
                                                                    array('session' => $session, 
                                                                                'module_name' => 'User', 
                                                                                'query' => $query, 
                                                                                'order_by' => $orderby, 
                                                                                'offset' => 0, 
                                                                                'select_fields' => array('id', 'user_name', 'first_name', 'last_name'),  
                                                                                'max_results' => $maxnum, 
                                                                                'deleted' => false));
    return $result;
} 


/*-------- Perform access SugarCRM API ----*/
function sugar_execute_command($url, $method, $data) {
  ob_start();
  $ch = curl_init();
  $headers = (function_exists('getallheaders'))?getallheaders(): array();
  $_headers = array();
  foreach($headers as $k=>$v){
      $_headers[strtolower($k)] = $v;
  }
  // set URL and other appropriate options
  curl_setopt($ch, CURLOPT_URL, $url);
  curl_setopt ($ch, CURLOPT_POST, 1);
  //curl_setopt($ch, CURLOPT_HTTPHEADER, $_headers);
  //curl_setopt($ch, CURLOPT_HEADER, 1);
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
  curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 0);
  curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_0 );
  
  $post_data = 'method=' . $method . '&input_type=JSON&response_type=JSON&rest_data=';
  $post_data .= json_encode($data);

  curl_setopt($ch, CURLOPT_POSTFIELDS, $post_data);
  $result = curl_exec($ch);
  curl_close($ch);
  return json_decode($result);
}
?>

