<?php

class Config
{
    // set the $mls_name for a given MLS and the rest of the config will get set in the
    // switch statement lower down
    public $mls_name = 'CoreLogic';

    public $mls_logo;
    public $locations;
    public $user_data_url;

    /* default database settings */
    public $dbtype = 'mysql';
    public $dbname = 'aggdata';
    public $dbhost = 'localhost';
    public $dbuser = 'reports';
    public $dbpass = '';

    /* other defaults */
    public $show_logo_on_cover = false;
    public $show_dom_widget = true;
    public $chart_bar_label = "Closed Sales";
    public $footnote_active = "";
    public $footnote_standard = "";

    /* pod placement */
    /* made up of two arrays:
	1. section name
	2. corresponding report_details index
    */
    public $podmap = array( 
                    "pod-11" => array(array("new_listings_section"=>2)),
                    "pod-12" => array(array("new_pending_listings_section"=>10)),
                    "pod-13" => array(array("closed_sales_section"=>1)),
                    "pod-21" => array(array("median_sold_price_section"=>6)),
                    "pod-31" => array(array("active_listings_section"=>3)),
                    "pod-32" => array(array("avg_dom_before_sale_section"=>7)),
                    "pod-33" => array(array("avg_sold_to_olp_ratio_section"=>9))
           );

    function __construct()
    {
        switch ($this->mls_name) {
            case "ARMLS":
                $this->mls_logo = 'ARMLS-logo-165x64.png';
                $this->show_logo_on_cover = true;
                $this->locations = array(1, 2, 4, 6);
                $this->dbname = 'ARMLS_aggdata_patch';
                $this->user_data_url = "http://www.armls.rbintel.com/userinfo/?user=";
                $this->chart_bar_label = "New Contracts";
                $this->footnote_active = "&bull; When calculating the Contract Ratio, the number of Contracts (Pending and AWC) are divided by the number of Active listings";
                break;
            case "CAAR":
                $this->mls_logo = 'CAAR-logo-218x100.jpg';
                $this->locations = array(1, 2, 4);
                $this->dbname = 'CAAR_aggdata';
                break;
            case "CVRMLS":
                $this->mls_logo = 'CVRMLS-logo-250x100.png';
                $this->locations = array(1, 2, 4);
                $this->dbname = 'CVRMLS_aggdata';
                $this->show_dom_widget = false;
                break;
            case "MFRMLS":
                $this->mls_logo = 'MFRMLS-logo-167x100.jpg';
                $this->locations = array(1, 2, 3, 4);
                $this->dbname = 'MFRMLS_aggdata';
                break;
            case "MRIS":
                $this->mls_logo = 'rbi-logo-166x50.jpg';
                $this->locations = array(1, 2, 3, 4);
                $this->dbname = 'aggdata';
                break;
            case "CoreLogic":
                #$this->mls_logo = 'Innovia-logo-215x105.png';
                #$this->mls_logo = 'core_logic_logo.png';
                $this->mls_logo = 'market_trends_premium.png';
                $this->locations = array(1, 4, 6);
                #$this->dbname = 'CLLIS_aggdata';
                $this->dbname = 'MLS_217_AGG';
                $this->user_data_url = "http://www.marketrendspremium.com/userinfo/test.php?user=";

                $this->podmap["pod-12"] = array(array("closed_sales_section"=>1));
                $this->podmap["pod-13"] = array(array("new_pending_listings_section"=>10), array("average_sold_price_section"=>5));
                $this->podmap["pod-32"] = array(array("median_days_to_contract_section"=>59), array("median_days_to_settle_section"=>33));
                $this->podmap["pod-33"] = array(array("avg_sold_to_olp_ratio_section"=>4), array("average_sold_dollars_per_sqft_section"=>36));
                break;
        }
    }

}
