<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <title>Local Market Insight Report</title>
  <link type="text/css" rel="stylesheet" media="all" href="css/LocalMarketInsight.css"/>
  <script src="js/jquery.min.js" type="text/javascript"></script>
  <script src="js/highcharts.js" type="text/javascript"></script>
  <script type="text/javascript">
			var chart;
			$(document).ready(function() {
				chart = new Highcharts.Chart({
					chart: {
						renderTo: 'median_sold_price_chart_container',
                        borderColor: '#FFFFFF',
                        borderWidth: 0,
                        spacingTop: 0,
                        style: {
                          fontFamily: 'Arial, Helvetica, sans-serif',
                          fontSize: '8px'
                        }
					},
					title: {
						text: ''
					},
                    credits: {
                        enabled:false
                    },
                    plotOptions: { 
                        series: { 
                            connectNulls: true,
                            enableMouseTracking: false, 
                            shadow: false, 
                            animation: false,
                            area: {
                              linewidth: 15,
                              radius: 2
                            },
                            marker: {
                              linewidth: 5,
                              radius: 2
                            }
                        }
                    },
					xAxis: [{
						categories: [{$chartDataXAxisMonth}],
                        labels: {
                            style: {
                               fontFamily: 'Arial, Helvetica, sans-serif',
                               fontSize: '8px'
                            }
                        }
					}, { // Secondary xAxis
						categories: [{$chartDataXAxisYear}],
                        labels: {
                            style: {
                               fontFamily: 'Arial, Helvetica, sans-serif',
                               fontSize: '8px'
                            }
                        },
                        offset: 18,
						tickInterval: 12
					}],
					yAxis: [{ // Primary yAxis
                        min: {$chartDataBarMin},
                        max: {$chartDataBarMax},
                        tickPixelInterval: 25,
						labels: {
							formatter: function() {
								return this.value;
							},
							style: {
							   color: '#4572A7',
                               fontFamily: 'Arial, Helvetica, sans-serif',
                               fontSize: '8px'
							}
						},
						title: {
							text: '',
							style: {
								color: '#4572A7'
							}
						}
					}, { // Secondary yAxis
                        min: {$chartDataMedianSoldPriceMin},
                        max: {$chartDataMedianSoldPriceMax},
                        tickPixelInterval: 20,
						title: {
							text: '',
							style: {
								color: '#9459A9'
							}
						},
						labels: {
							formatter: function() {
								return '$' + this.value;
							},
							style: {
							   color: '#9459A9',
                               fontFamily: 'Arial, Helvetica, sans-serif',
                               fontSize: '8px'
							}
						},
						opposite: true
					}],
					legend: {
						layout: 'horizontal',
                        width: 300,
                        itemWidth: 150,
						align: 'center',
                        borderWidth: 0,
						verticalAlign: 'top',
						floating: false,
                        borderColor: '#FFFFFF',
						backgroundColor: '#FFFFFF',
                        itemStyle: { 
                           fontFamily: 'Arial, Helvetica, sans-serif',
                           fontSize: '8px'
                        }
					},
					series: [{
						animation: false,
						name: '{$chartDataBarLabel}',
						color: '#60A8C8',
						type: 'column',
						pointWidth: '9',
						data: [{$chartDataBarData}]
					
					}, {
						animation: false,
						name: 'Median Sold Price ($1,000s)',
						color: '#9459A9',
						type: 'spline',
						xAxis: 1,
						yAxis: 1,
						data: [{$chartDataMedPrice}]
					}]
				});
			});
  </script>

</head>
<body>
  <div id="page">

   <div id="header">
      <div class="banner-bordertop"></div>
      <div class="local_market_insight_logo"><img src="img/LocalMarketInsight-logo-blue-414x64.jpg" width="207" height="32" alt="Local Market Insight" /></div>

      <div class="banner-date">{$currMonthTimestamp|date_format:"%B %Y"}</div>
      <div class="banner-location">{$locationName} - {$homeType}</div>
      <div class="banner-borderbottom"></div> 

      {if not isset($personalizedData)}
          <img src="img/{$mls_logo}" class="mls_logo" width="109" alt="mls-logo" /> 
      {else}
        <div class="banner-personalized">
        <div class="banner-personalized-top">
            <div class="banner-presented">Presented by</div>
            <div class="banner-name">{$personalizedData["first_name"]} {$personalizedData["last_name"]}</div>
        </div><!-- end id="banner-personalized-top" -->
        <div class="banner-personalized-bottom">
            <div class="banner-agency">{$personalizedData["office_name"]}</div>
            <div class="banner-details">
                 {if $personalizedData["email"]!=""}Email: {$personalizedData["email"]}<br/>{/if}
                 {if $personalizedData["primary_phone"]!=""}Phone: {$personalizedData["primary_phone"]}<br/>{/if}
                 {if $personalizedData["web_site"]!=""}Web: {$personalizedData["web_site"]}{/if}
            </div>
        </div><!-- end id="banner-personalized-bottom" -->
        </div><!-- end id="banner-personalized" -->
      {/if}
   </div><!-- end id="header" -->

   <div id="content">
{if isset($new_listings_section)}
              <div id="{$new_listings_section}">
               <div class="pod-Container pod-Text">
               <div class="pod-layer1">
                <div class="pod-H1">New Listings</div>
                <div class="pod-KeyQuantity">{$monthlyCurrMonth.num_new_listings|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer1" -->
               <div class="pod-layer2">
                <div class="pod-PrevMonth pod-Trend{$monthlyPrevMonthDiffDir.num_new_listings}"><img src="img/Arrow{$monthlyPrevMonthDiffDir.num_new_listings}-50x24.png" height="12" width="25" alt="" />{$monthlyPrevMonthDiff.num_new_listings}%</div>
                <div class="pod-PrevYear pod-Trend{$monthlyPrevYearDiffDir.num_new_listings}"><img src="img/Arrow{$monthlyPrevYearDiffDir.num_new_listings}-50x24.png" height="12" width="25" alt="" />{$monthlyPrevYearDiff.num_new_listings}%</div>
                <div class="pp_comp_title">from {$prevMonthTimestamp|date_format:"%b %Y"}:</div><div class="pp_comp_value pod-Strong">{$monthlyPrevMonth.num_new_listings|number_format:0:".":","}</div>
                <div class="py_comp_title">from {$prevYearTimestamp|date_format:"%b %Y"}:</div><div class="py_comp_value pod-Strong">{$monthlyPrevYear.num_new_listings|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer2" -->
               <img src="img/ShadowRule-170x8.png" class="shadow-border" alt="" />
               <div class="pod-layer3">
                  <div class="ytd_label">YTD</div>
                  <div class="ytd_curr_year_header">{$currMonthTimestamp|date_format:"%Y"}</div>
                  <div class="ytd_prev_year_header">{$prevYearTimestamp|date_format:"%Y"}</div>
                  <div class="ytd_percent_diff_header">+/-</div>
                  <div class="ytd_curr_year_value pod-StrongKey">{$ytdCurrYear.num_new_listings|number_format:0:".":","}</div>
                  <div class="ytd_prev_year_value pod-Strong">{$ytdPrevYear.num_new_listings|number_format:0:".":","}</div>
                  <div class="ytd_percent_diff_value">{$ytdPrevYearDiff.num_new_listings}%</div>
                  <img src="img/dottedline-308px.png" class="dotted-border" alt="" />
               </div><!-- end class=pod-layer3" -->
               <div class="pod-layer4">
                <div class="section_5yr_average">5-year {$currMonthTimestamp|date_format:"%b"} average:&nbsp;&nbsp;<span class="pod-Strong">{$monthlyFiveYearStats.num_new_listings["avg"]|number_format:0:".":","}</span></div>
               </div><!-- end class=pod-layer4" -->
               </div><!-- end id="pod-Container pod-Text" -->
              </div><!-- end id="new_listings_section" -->
{/if}

{if isset($new_pending_listings_section)}
              <div id="{$new_pending_listings_section}">
               <div class="pod-Container pod-Text">
               <div class="pod-layer1">
                <div class="pod-H1">New Pendings</div>
                <div class="pod-KeyQuantity">{$monthlyCurrMonth.num_new_pending_listings|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer1" -->
               <div class="pod-layer2">
                <div class="pod-PrevMonth pod-Trend{$monthlyPrevMonthDiffDir.num_new_pending_listings}"><img src="img/Arrow{$monthlyPrevMonthDiffDir.num_new_pending_listings}-50x24.png" height="12" width="25" alt="" />{$monthlyPrevMonthDiff.num_new_pending_listings}%</div>
                <div class="pod-PrevYear pod-Trend{$monthlyPrevYearDiffDir.num_new_pending_listings}"><img src="img/Arrow{$monthlyPrevYearDiffDir.num_new_pending_listings}-50x24.png" height="12" width="25" alt="" />{$monthlyPrevYearDiff.num_new_pending_listings}%</div>
                <div class="pp_comp_title">from {$prevMonthTimestamp|date_format:"%b %Y"}:</div><div class="pp_comp_value pod-Strong">{$monthlyPrevMonth.num_new_pending_listings|number_format:0:".":","}</div>
                <div class="py_comp_title">from {$prevYearTimestamp|date_format:"%b %Y"}:</div><div class="py_comp_value pod-Strong">{$monthlyPrevYear.num_new_pending_listings|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer2" -->
               <img src="img/ShadowRule-170x8.png" class="shadow-border" alt="" />
               <div class="pod-layer3">
                  <div class="ytd_label">YTD</div>
                  <div class="ytd_curr_year_header">{$currMonthTimestamp|date_format:"%Y"}</div>
                  <div class="ytd_prev_year_header">{$prevYearTimestamp|date_format:"%Y"}</div>
                  <div class="ytd_percent_diff_header">+/-</div>
                  <div class="ytd_curr_year_value pod-StrongKey">{$ytdCurrYear.num_new_pending_listings|number_format:0:".":","}</div>
                  <div class="ytd_prev_year_value pod-Strong">{$ytdPrevYear.num_new_pending_listings|number_format:0:".":","}</div>
                  <div class="ytd_percent_diff_value">{$ytdPrevYearDiff.num_new_pending_listings}%</div>
                  <img src="img/dottedline-308px.png" class="dotted-border" alt="" />
               </div><!-- end class=pod-layer3" -->
               <div class="pod-layer4">
                <div class="section_5yr_average">5-year {$currMonthTimestamp|date_format:"%b"} average:&nbsp;&nbsp;<span class="pod-Strong">{$monthlyFiveYearStats.num_new_pending_listings["avg"]|number_format:0:".":","}</span></div>
               </div><!-- end class=pod-layer4" -->
               </div><!-- end id="pod-Container pod-Text" -->
              </div><!-- end id="new_pending_listings_section" -->
{/if}

{if isset($average_sold_price_section)}
              <div id="{$average_sold_price_section}">
               <div class="pod-Container pod-Text">
               <div class="pod-layer1">
                <div class="pod-H1">Average<br>Sold Price</div>
                <div class="pod-KeyQuantity">${$monthlyCurrMonth.sld_avg_sp|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer1" -->
               <div class="pod-layer2">
                <div class="pod-PrevMonth pod-Trend{$monthlyPrevMonthDiffDir.sld_avg_sp}"><img src="img/Arrow{$monthlyPrevMonthDiffDir.sld_avg_sp}-50x24.png" height="12" width="25" alt="" />{$monthlyPrevMonthDiff.sld_avg_sp}%</div>
                <div class="pod-PrevYear pod-Trend{$monthlyPrevYearDiffDir.sld_avg_sp}"><img src="img/Arrow{$monthlyPrevYearDiffDir.sld_avg_sp}-50x24.png" height="12" width="25" alt="" />{$monthlyPrevYearDiff.sld_avg_sp}%</div>
                <div class="pp_comp_title">from {$prevMonthTimestamp|date_format:"%b %Y"}:</div><div class="pp_comp_value pod-Strong">${$monthlyPrevMonth.sld_avg_sp|number_format:0:".":","}</div>
                <div class="py_comp_title">from {$prevYearTimestamp|date_format:"%b %Y"}:</div><div class="py_comp_value pod-Strong">${$monthlyPrevYear.sld_avg_sp|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer2" -->
               <img src="img/ShadowRule-170x8.png" class="shadow-border" alt="" />
               <div class="pod-layer3">
                  <div class="ytd_label">YTD</div>
                  <div class="ytd_curr_year_header">{$currMonthTimestamp|date_format:"%Y"}</div>
                  <div class="ytd_prev_year_header">{$prevYearTimestamp|date_format:"%Y"}</div>
                  <div class="ytd_percent_diff_header">+/-</div>
                  <div class="ytd_curr_year_value pod-StrongKey">${$ytdCurrYear.sld_avg_sp|number_format:0:".":","}</div>
                  <div class="ytd_prev_year_value pod-Strong">${$ytdPrevYear.sld_avg_sp|number_format:0:".":","}</div>
                  <div class="ytd_percent_diff_value">{$ytdPrevYearDiff.sld_avg_sp}%</div>
                  <img src="img/dottedline-308px.png" class="dotted-border" alt="" />
               </div><!-- end class=pod-layer3" -->
               <div class="pod-layer4">
                <div class="section_5yr_average">5-year {$currMonthTimestamp|date_format:"%b"} average:&nbsp;&nbsp;<span class="pod-Strong">${$monthlyFiveYearStats.sld_avg_sp["avg"]|number_format:0:".":","}</span></div>
               </div><!-- end class=pod-layer4" -->
               </div><!-- end id="pod-Container pod-Text" -->
              </div><!-- end id="average_sold_price_section" -->
{/if}

{if isset($closed_sales_section)}
              <div id="{$closed_sales_section}">
               <div class="pod-Container pod-Text">
               <div class="pod-layer1">
                <div class="pod-H1">Closed Sales</div>
                <div class="pod-KeyQuantity">{$monthlyCurrMonth.num_sold_listings|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer1" -->
               <div class="pod-layer2">
                <div class="pod-PrevMonth pod-Trend{$monthlyPrevMonthDiffDir.num_sold_listings}"><img src="img/Arrow{$monthlyPrevMonthDiffDir.num_sold_listings}-50x24.png" height="12" width="25" alt="" />{$monthlyPrevMonthDiff.num_sold_listings}%</div>
                <div class="pod-PrevYear pod-Trend{$monthlyPrevYearDiffDir.num_sold_listings}"><img src="img/Arrow{$monthlyPrevYearDiffDir.num_sold_listings}-50x24.png" height="12" width="25" alt="" />{$monthlyPrevYearDiff.num_sold_listings}%</div>
                <div class="pp_comp_title">from {$prevMonthTimestamp|date_format:"%b %Y"}:</div><div class="pp_comp_value pod-Strong">{$monthlyPrevMonth.num_sold_listings|number_format:0:".":","}</div>
                <div class="py_comp_title">from {$prevYearTimestamp|date_format:"%b %Y"}:</div><div class="py_comp_value pod-Strong">{$monthlyPrevYear.num_sold_listings|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer2" -->
               <img src="img/ShadowRule-170x8.png" class="shadow-border" alt="" />
               <div class="pod-layer3">
                  <div class="ytd_label">YTD</div>
                  <div class="ytd_curr_year_header">{$currMonthTimestamp|date_format:"%Y"}</div>
                  <div class="ytd_prev_year_header">{$prevYearTimestamp|date_format:"%Y"}</div>
                  <div class="ytd_percent_diff_header">+/-</div>
                  <div class="ytd_curr_year_value pod-StrongKey">{$ytdCurrYear.num_sold_listings|number_format:0:".":","}</div>
                  <div class="ytd_prev_year_value pod-Strong">{$ytdPrevYear.num_sold_listings|number_format:0:".":","}</div>
                  <div class="ytd_percent_diff_value">{$ytdPrevYearDiff.num_sold_listings}%</div>
                  <img src="img/dottedline-308px.png" class="dotted-border" alt="" />
               </div><!-- end class=pod-layer3" -->
               <div class="pod-layer4">
                <div class="section_5yr_average">5-year {$currMonthTimestamp|date_format:"%b"} average:&nbsp;&nbsp;<span class="pod-Strong">{$monthlyFiveYearStats.num_sold_listings["avg"]|number_format:0:".":","}</span></div>
               </div><!-- end class=pod-layer4" -->
               </div><!-- end id="pod-Container pod-Text" -->
              </div><!-- end id="closed_sales_section" -->
{/if}

{if isset($median_sold_price_section)}
              <div id="{$median_sold_price_section}">
               <div class="pod-Container pod-Text">
               <div class="pod-layer1">
                <div class="pod-H1">Median<br>Sold Price</div>
                <div class="pod-KeyQuantity">${$monthlyCurrMonth.sld_med_sp|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer1" -->
               <div class="pod-layer2">
                <div class="pod-PrevMonth pod-Trend{$monthlyPrevMonthDiffDir.sld_med_sp}"><img src="img/Arrow{$monthlyPrevMonthDiffDir.sld_med_sp}-50x24.png" height="12" width="25" alt="" />{$monthlyPrevMonthDiff.sld_med_sp}%</div>
                <div class="pod-PrevYear pod-Trend{$monthlyPrevYearDiffDir.sld_med_sp}"><img src="img/Arrow{$monthlyPrevYearDiffDir.sld_med_sp}-50x24.png" height="12" width="25" alt="" />{$monthlyPrevYearDiff.sld_med_sp}%</div>
                <div class="pp_comp_title">from {$prevMonthTimestamp|date_format:"%b %Y"}:</div><div class="pp_comp_value pod-Strong">${$monthlyPrevMonth.sld_med_sp|number_format:0:".":","}</div>
                <div class="py_comp_title">from {$prevYearTimestamp|date_format:"%b %Y"}:</div><div class="py_comp_value pod-Strong">${$monthlyPrevYear.sld_med_sp|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer2" -->
               <img src="img/ShadowRule-170x8.png" class="shadow-border" alt="" />
               <div class="pod-layer3">
                  <div class="ytd_label">YTD</div>
                  <div class="ytd_curr_year_header">{$currMonthTimestamp|date_format:"%Y"}</div>
                  <div class="ytd_prev_year_header">{$prevYearTimestamp|date_format:"%Y"}</div>
                  <div class="ytd_percent_diff_header">+/-</div>
                  <div class="ytd_curr_year_value pod-StrongKey">${$ytdCurrYear.sld_med_sp|number_format:0:".":","}</div>
                  <div class="ytd_prev_year_value pod-Strong">${$ytdPrevYear.sld_med_sp|number_format:0:".":","}</div>
                  <div class="ytd_percent_diff_value">{$ytdPrevYearDiff.sld_med_sp}%</div>
                  <img src="img/dottedline-308px.png" class="dotted-border" alt="" />
               </div><!-- end class=pod-layer3" -->
               <div class="pod-layer4">
                <div class="section_5yr_average">5-year {$currMonthTimestamp|date_format:"%b"} average:&nbsp;&nbsp;<span class="pod-Strong">${$monthlyFiveYearStats.sld_med_sp["avg"]|number_format:0:".":","}</span></div>
               </div><!-- end class=pod-layer4" -->
               </div><!-- end id="pod-Container pod-Text" -->
              </div><!-- end id="median_sold_price_section" -->
{/if}

              <div id="median_sold_price_chart_section" class="summary">
               <div class="pod-Container-Wide pod-Text">
               <div class="pod-layer1">
                 <div class="pod-H1 summary">Summary</div>
               </div><!-- end class=pod-layer1" -->
               <div class="pod-layer2 summary">

               <div id="summary_text" style="width: 360px; height: 180px; margin: 0 auto">
<p>
In {$locationName}, the median sold price for {$homeType} properties
for {$currMonthTimestamp|date_format:"%B"} was ${$monthlyCurrMonth.sld_med_sp|number_format:0:".":","},
representing
             {if floor($monthlyPrevMonth.sld_med_sp)==floor($monthlyCurrMonth.sld_med_sp)}no change
             {else} {if floor($monthlyCurrMonth.sld_med_sp)>floor($monthlyPrevMonth.sld_med_sp)}an increase{else}a decrease{/if} of {$monthlyPrevMonthDiff.sld_med_sp|abs}%
             {/if}
compared to last month and
             {if floor($monthlyPrevYear.sld_med_sp)==floor($monthlyCurrMonth.sld_med_sp)}no change
             {else} {if floor($monthlyCurrMonth.sld_med_sp)>floor($monthlyPrevYear.sld_med_sp)}an increase{else}a decrease{/if} of {$monthlyPrevYearDiff.sld_med_sp|abs}%
             {/if}
from {$prevYearTimestamp|date_format:"%b %Y"}.
The average days on market for units sold in {$currMonthTimestamp|date_format:"%B"} was {$monthlyCurrMonth.sld_avg_dom|number_format:0:".":","} days,
             {if abs($monthlyFiveYearStats.sld_avg_dom["diff"])<1}the same as
             {else} {$monthlyFiveYearStats.sld_avg_dom["diff"]|abs|number_format:0:".":","}% {if $monthlyFiveYearStats.sld_avg_dom["diff"]>0}above{else}below{/if}
             {/if}
the 5-year {$currMonthTimestamp|date_format:"%B"} average of {$monthlyFiveYearStats.sld_avg_dom["avg"]|number_format:0:".":","} days.  There was
             {if floor($monthlyPrevMonth.num_new_pending_listings)==floor($monthlyCurrMonth.num_new_pending_listings)}no month over month change
             {else} {if in_array(floor(abs($monthlyPrevMonthDiff.num_new_pending_listings)), $vowelNumbers)}an{else}a{/if}
                    {$monthlyPrevMonthDiff.num_new_pending_listings|abs}% month over month {if floor($monthlyCurrMonth.num_new_pending_listings)>floor($monthlyPrevMonth.num_new_pending_listings)}increase{else}decrease{/if}
             {/if}
in new contract activity with {$monthlyCurrMonth.num_new_pending_listings|number_format:0:".":","} {$new_pendings_label};
             {if floor($monthlyPrevMonth.num_pending_listings)==floor($monthlyCurrMonth.num_pending_listings)}no MoM change
             {else} {if in_array(floor(abs($monthlyPrevMonthDiff.num_pending_listings)), $vowelNumbers)}an{else}a{/if}
                    {$monthlyPrevMonthDiff.num_pending_listings|abs}% MoM {if floor($monthlyCurrMonth.num_pending_listings)>floor($monthlyPrevMonth.num_pending_listings)}increase{else}decrease{/if}
             {/if}
in All Pendings (new contracts + contracts carried over from {$prevMonthTimestamp|date_format:"%B"})
             {if floor($monthlyPrevMonth.num_pending_listings)==floor($monthlyCurrMonth.num_pending_listings)}with
             {else}to
             {/if}
{$monthlyCurrMonth.num_pending_listings|number_format:0:".":","}; and
             {if floor($monthlyPrevMonth.num_active_listings)==floor($monthlyCurrMonth.num_active_listings)}no change
             {else} {if in_array(floor(abs($monthlyPrevMonthDiff.num_active_listings)), $vowelNumbers)}an{else}a{/if}
                    {$monthlyPrevMonthDiff.num_active_listings|abs}% {if floor($monthlyCurrMonth.num_active_listings)>floor($monthlyPrevMonth.num_active_listings)}increase{else}decrease{/if}
             {/if}
in supply
             {if floor($monthlyPrevMonth.num_active_listings)==floor($monthlyCurrMonth.num_active_listings)}with
             {else}to
             {/if}
{$monthlyCurrMonth.num_active_listings|number_format:0:".":","} active units.
</p><p>
This activity resulted in a Contract Ratio of {$monthlyCurrMonth.contract_ratio|number_format:2:".":","} pendings per active listing,
             {if floor($monthlyPrevMonth.contract_ratio)==floor($monthlyCurrMonth.contract_ratio)}no change from
             {else} {if floor($monthlyCurrMonth.contract_ratio)>floor($monthlyPrevMonth.contract_ratio)}up{else}down{/if} from {$monthlyPrevMonth.contract_ratio|number_format:2:".":","} in
             {/if}
{$prevMonthTimestamp|date_format:"%B"} and
             {if floor($monthlyPrevYear.contract_ratio)==floor($monthlyCurrMonth.contract_ratio)}no change from
             {else} {if floor($monthlyCurrMonth.contract_ratio)>floor($monthlyPrevYear.contract_ratio)}an increase{else}a decrease{/if} from {$monthlyPrevYear.contract_ratio|number_format:2:".":","} in
             {/if}
{$prevYearTimestamp|date_format:"%B %Y"}.
The Contract Ratio is
            {if abs($monthlyFiveYearStats.contract_ratio["diff"])<1}the same as
            {else} {$monthlyFiveYearStats.contract_ratio["diff"]|abs|number_format:0:".":","}% {if $monthlyFiveYearStats.contract_ratio["diff"]>0}higher{else}lower{/if} than
            {/if}
the 5-year {$currMonthTimestamp|date_format:"%B"} average of {$monthlyFiveYearStats.contract_ratio["avg"]|abs|number_format:2:".":","}.
A higher Contract Ratio signifies a relative increase in contract activity compared to supply, and indicates the market is moving in the seller's favor.
A lower Contract Ratio signifies a relative decrease in contract activity compared to supply, and indicates the market is moving in the buyer's favor.
</p></div>
              </div><!-- end class=pod-layer2" -->
              </div><!-- end id="median_sold_price_chart_section" -->
              </div>

{if isset($active_listings_section)}
              <div id="{$active_listings_section}" class="summary">
               <div class="pod-Container pod-Text">
               <div class="pod-layer1">
                <div class="pod-H1">Active Listings</div>
                <div class="pod-KeyQuantity">{$monthlyCurrMonth.num_active_listings|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer1" -->
               <div class="pod-layer2">
                 <img src="img/ScaleGraduatedGreen-152x10.png" class="scale_graduated" alt="" />
                 <div class="scale_graduated_min">Min<BR>{$monthlyFiveYearStats.num_active_listings["min"]|number_format:0:".":","}</div>
                 <div class="scale_graduated_max">Max<BR>{$monthlyFiveYearStats.num_active_listings["max"]|number_format:0:".":","}</div>
                 <div class="scale_graduated_subtitle">5-year {$currMonthTimestamp|date_format:"%b"} average</div>
                 {math assign="active_listings_section_pixels_per_unit" equation="pixel_width/(units_max-units_min)" pixel_width=152.0 units_max=$monthlyFiveYearStats.num_active_listings["max"] units_min=$monthlyFiveYearStats.num_active_listings["min"]}
                 {math assign="active_listings_section_tbb" equation="(units-units_min)*pixels_per_unit" units=$monthlyCurrMonth.num_active_listings units_min=$monthlyFiveYearStats.num_active_listings["min"] pixels_per_unit=$active_listings_section_pixels_per_unit}
                 {math assign="active_listings_section_tst" equation="(units-units_min)*pixels_per_unit" units=$monthlyFiveYearStats.num_active_listings["avg"] units_min=$monthlyFiveYearStats.num_active_listings["min"] pixels_per_unit=$active_listings_section_pixels_per_unit}
                 <div class="scale_graduated_trianglebigblue" style="margin-left:{$active_listings_section_tbb|number_Format:0}px">{$monthlyCurrMonth.num_active_listings|number_format:0:".":","}<br><img src="img/TriangleBigBlue-26x22.png" width="13" height="11" alt="" /></div>
                 <div class="scale_graduated_trianglesmallteal" style="margin-left:{$active_listings_section_tst|number_Format:0}px"><img src="img/TriangleSmallTeal-18x16.png" width="8" height="9" alt="" /><br>{$monthlyFiveYearStats.num_active_listings["avg"]|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer2" -->
               <img src="img/ShadowRule-170x8.png" class="shadow-border-low" alt="" />
               <div class="pod-layer3">
                  <div class="prev_month_header">{$prevMonthTimestamp|date_format:"%b %Y"}</div>
                  <div class="prev_year_header">{$prevYearTimestamp|date_format:"%b %Y"}</div>
                  <div class="prev_month_value pod-Strong">{$monthlyPrevMonth.num_active_listings|number_format:0:".":","}</div>
                  <div class="prev_year_value pod-Strong">{$monthlyPrevYear.num_active_listings|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer3" -->
               </div><!-- end id="pod-Container pod-Text" -->
              </div><!-- end id="active_listings_section" -->
{/if}

{if isset($avg_dom_before_sale_section)}
              <div id="{$avg_dom_before_sale_section}" class="summary">
               <div class="pod-Container pod-Text">
               <div class="pod-layer1">
                <div class="pod-H1">Avg DOM</div>
                <div class="pod-KeyQuantity">{$monthlyCurrMonth.sld_avg_dom|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer1" -->
               <div class="pod-layer2">
                 <img src="img/ScaleGraduatedRed-152x10.png" class="scale_graduated" alt="" />
                 <div class="scale_graduated_min">Min<BR>{$monthlyFiveYearStats.sld_avg_dom["min"]|number_format:0:".":","}</div>
                 <div class="scale_graduated_max">Max<BR>{$monthlyFiveYearStats.sld_avg_dom["max"]|number_format:0:".":","}</div>
                 <div class="scale_graduated_subtitle">5-year {$currMonthTimestamp|date_format:"%b"} average</div>
                 {math assign="avg_dom_before_sale_section_pixels_per_unit" equation="pixel_width/(units_max-units_min)" pixel_width=152.0 units_max=$monthlyFiveYearStats.sld_avg_dom["max"] units_min=$monthlyFiveYearStats.sld_avg_dom["min"]}
                 {math assign="avg_dom_before_sale_section_tbb" equation="(units-units_min)*pixels_per_unit" units=$monthlyCurrMonth.sld_avg_dom units_min=$monthlyFiveYearStats.sld_avg_dom["min"] pixels_per_unit=$avg_dom_before_sale_section_pixels_per_unit}
                 {math assign="avg_dom_before_sale_section_tst" equation="(units-units_min)*pixels_per_unit" units=$monthlyFiveYearStats.sld_avg_dom["avg"] units_min=$monthlyFiveYearStats.sld_avg_dom["min"] pixels_per_unit=$avg_dom_before_sale_section_pixels_per_unit}
                 <div class="scale_graduated_trianglebigblue" style="margin-left:{$avg_dom_before_sale_section_tbb|number_Format:0}px">{$monthlyCurrMonth.sld_avg_dom|number_format:0:".":","}<br><img src="img/TriangleBigBlue-26x22.png" width="13" height="11" alt="" /></div>
                 <div class="scale_graduated_trianglesmallteal" style="margin-left:{$avg_dom_before_sale_section_tst|number_Format:0}px"><img src="img/TriangleSmallTeal-18x16.png" width="8" height="9" alt="" /><br>{$monthlyFiveYearStats.sld_avg_dom["avg"]|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer2" -->
               <img src="img/ShadowRule-170x8.png" class="shadow-border-low" alt="" />
               <div class="pod-layer3">
                  <div class="prev_month_header">{$prevMonthTimestamp|date_format:"%b %Y"}</div>
                  <div class="prev_year_header">{$prevYearTimestamp|date_format:"%b %Y"}</div>
                  <div class="ytd_year_header">YTD</div>
                  <div class="prev_month_value pod-Strong">{$monthlyPrevMonth.sld_avg_dom|number_format:0:".":","}</div>
                  <div class="prev_year_value pod-Strong">{$monthlyPrevYear.sld_avg_dom|number_format:0:".":","}</div>
                  <div class="ytd_year_value pod-Strong">{$ytdCurrYear.sld_avg_dom|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer3" -->
               </div><!-- end id="pod-Container pod-Text" -->
              </div><!-- end id="avg_dom_before_sale_section" -->
{/if}

{if isset($median_days_to_contract_section)}
              <div id="{$median_days_to_contract_section}" class="summary">
               <div class="pod-Container pod-Text">
               <div class="pod-layer1">
                <div class="pod-H1">Median<BR>Days to Contract</div>
                <div class="pod-KeyQuantity">{$monthlyCurrMonth.sld_med_days_to_contract|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer1" -->
               <div class="pod-layer2">
                 <img src="img/ScaleGraduatedRed-152x10.png" class="scale_graduated" alt="" />
                 <div class="scale_graduated_min">Min<BR>{$monthlyFiveYearStats.sld_med_days_to_contract["min"]|number_format:0:".":","}</div>
                 <div class="scale_graduated_max">Max<BR>{$monthlyFiveYearStats.sld_med_days_to_contract["max"]|number_format:0:".":","}</div>
                 <div class="scale_graduated_subtitle">5-year {$currMonthTimestamp|date_format:"%b"} average</div>
                 {math assign="avg_dom_before_sale_section_pixels_per_unit" equation="pixel_width/(units_max-units_min)" pixel_width=152.0 units_max=$monthlyFiveYearStats.sld_med_days_to_contract["max"] units_min=$monthlyFiveYearStats.sld_med_days_to_contract["min"]}
                 {math assign="avg_dom_before_sale_section_tbb" equation="(units-units_min)*pixels_per_unit" units=$monthlyCurrMonth.sld_med_days_to_contract units_min=$monthlyFiveYearStats.sld_med_days_to_contract["min"] pixels_per_unit=$avg_dom_before_sale_section_pixels_per_unit}
                 {math assign="avg_dom_before_sale_section_tst" equation="(units-units_min)*pixels_per_unit" units=$monthlyFiveYearStats.sld_med_days_to_contract["avg"] units_min=$monthlyFiveYearStats.sld_med_days_to_contract["min"] pixels_per_unit=$avg_dom_before_sale_section_pixels_per_unit}
                 <div class="scale_graduated_trianglebigblue" style="margin-left:{$avg_dom_before_sale_section_tbb|number_Format:0}px">{$monthlyCurrMonth.sld_med_days_to_contract|number_format:0:".":","}<br><img src="img/TriangleBigBlue-26x22.png" width="13" height="11" alt="" /></div>
                 <div class="scale_graduated_trianglesmallteal" style="margin-left:{$avg_dom_before_sale_section_tst|number_Format:0}px"><img src="img/TriangleSmallTeal-18x16.png" width="8" height="9" alt="" /><br>{$monthlyFiveYearStats.sld_med_days_to_contract["avg"]|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer2" -->
               <img src="img/ShadowRule-170x8.png" class="shadow-border-low" alt="" />
               <div class="pod-layer3">
                  <div class="prev_month_header">{$prevMonthTimestamp|date_format:"%b %Y"}</div>
                  <div class="prev_year_header">{$prevYearTimestamp|date_format:"%b %Y"}</div>
                  <div class="ytd_year_header">YTD</div>
                  <div class="prev_month_value pod-Strong">{$monthlyPrevMonth.sld_med_days_to_contract|number_format:0:".":","}</div>
                  <div class="prev_year_value pod-Strong">{$monthlyPrevYear.sld_med_days_to_contract|number_format:0:".":","}</div>
                  <div class="ytd_year_value pod-Strong">{$ytdCurrYear.sld_med_days_to_contract|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer3" -->
               </div><!-- end id="pod-Container pod-Text" -->
              </div><!-- end id="median_days_to_contract_section" -->
{/if}

{if isset($median_days_to_settle_section)}
              <div id="{$median_days_to_settle_section}" class="summary">
               <div class="pod-Container pod-Text">
               <div class="pod-layer1">
                <div class="pod-H1">Median<BR>Days to Settle</div>
                <div class="pod-KeyQuantity">{$monthlyCurrMonth.sld_med_days_to_settle|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer1" -->
               <div class="pod-layer2">
                 <img src="img/ScaleGraduatedRed-152x10.png" class="scale_graduated" alt="" />
                 <div class="scale_graduated_min">Min<BR>{$monthlyFiveYearStats.sld_med_days_to_settle["min"]|number_format:0:".":","}</div>
                 <div class="scale_graduated_max">Max<BR>{$monthlyFiveYearStats.sld_med_days_to_settle["max"]|number_format:0:".":","}</div>
                 <div class="scale_graduated_subtitle">5-year {$currMonthTimestamp|date_format:"%b"} average</div>
                 {math assign="avg_dom_before_sale_section_pixels_per_unit" equation="pixel_width/(units_max-units_min)" pixel_width=152.0 units_max=$monthlyFiveYearStats.sld_med_days_to_settle["max"] units_min=$monthlyFiveYearStats.sld_med_days_to_settle["min"]}
                 {math assign="avg_dom_before_sale_section_tbb" equation="(units-units_min)*pixels_per_unit" units=$monthlyCurrMonth.sld_med_days_to_settle units_min=$monthlyFiveYearStats.sld_med_days_to_settle["min"] pixels_per_unit=$avg_dom_before_sale_section_pixels_per_unit}
                 {math assign="avg_dom_before_sale_section_tst" equation="(units-units_min)*pixels_per_unit" units=$monthlyFiveYearStats.sld_med_days_to_settle["avg"] units_min=$monthlyFiveYearStats.sld_med_days_to_settle["min"] pixels_per_unit=$avg_dom_before_sale_section_pixels_per_unit}
                 <div class="scale_graduated_trianglebigblue" style="margin-left:{$avg_dom_before_sale_section_tbb|number_Format:0}px">{$monthlyCurrMonth.sld_med_days_to_settle|number_format:0:".":","}<br><img src="img/TriangleBigBlue-26x22.png" width="13" height="11" alt="" /></div>
                 <div class="scale_graduated_trianglesmallteal" style="margin-left:{$avg_dom_before_sale_section_tst|number_Format:0}px"><img src="img/TriangleSmallTeal-18x16.png" width="8" height="9" alt="" /><br>{$monthlyFiveYearStats.sld_med_days_to_settle["avg"]|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer2" -->
               <img src="img/ShadowRule-170x8.png" class="shadow-border-low" alt="" />
               <div class="pod-layer3">
                  <div class="prev_month_header">{$prevMonthTimestamp|date_format:"%b %Y"}</div>
                  <div class="prev_year_header">{$prevYearTimestamp|date_format:"%b %Y"}</div>
                  <div class="ytd_year_header">YTD</div>
                  <div class="prev_month_value pod-Strong">{$monthlyPrevMonth.sld_med_days_to_settle|number_format:0:".":","}</div>
                  <div class="prev_year_value pod-Strong">{$monthlyPrevYear.sld_med_days_to_settle|number_format:0:".":","}</div>
                  <div class="ytd_year_value pod-Strong">{$ytdCurrYear.sld_med_days_to_settle|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer3" -->
               </div><!-- end id="pod-Container pod-Text" -->
              </div><!-- end id="median_days_to_settle_section" -->
{/if}

{if isset($avg_sold_to_olp_ratio_section)}
              <div id="{$avg_sold_to_olp_ratio_section}" class="summary">
               <div class="pod-Container pod-Text">
               <div class="pod-layer1">
                <div class="pod-H1">Avg Sold to<br>OLP Ratio</div>
                <div class="pod-KeyQuantity">{(100.0*$monthlyCurrMonth.sld_avg_sp_to_olp_ratio)|number_format:1:".":","}%</div>
               </div><!-- end class=pod-layer1" -->
               <div class="pod-layer2">
                 <img src="img/ScaleGraduatedGreen-152x10.png" class="scale_graduated" alt="" />
                 <div class="scale_graduated_min">Min<BR>{(100.0*$monthlyFiveYearStats.sld_avg_sp_to_olp_ratio["min"])|number_format:1:".":","}%</div>
                 <div class="scale_graduated_max">Max<BR>{(100.0*$monthlyFiveYearStats.sld_avg_sp_to_olp_ratio["max"])|number_format:1:".":","}%</div>
                 <div class="scale_graduated_subtitle">5-year {$currMonthTimestamp|date_format:"%b"} average</div>
                 {math assign="avg_sold_to_olp_ratio_pixels_per_unit" equation="pixel_width/(units_max-units_min)" pixel_width=152.0 units_max=$monthlyFiveYearStats.sld_avg_sp_to_olp_ratio["max"] units_min=$monthlyFiveYearStats.sld_avg_sp_to_olp_ratio["min"]}
                 {math assign="avg_sold_to_olp_ratio_tbb" equation="(units-units_min)*pixels_per_unit" units=$monthlyCurrMonth.sld_avg_sp_to_olp_ratio units_min=$monthlyFiveYearStats.sld_avg_sp_to_olp_ratio["min"] pixels_per_unit=$avg_sold_to_olp_ratio_pixels_per_unit}
                 {math assign="avg_sold_to_olp_ratio_tst" equation="(units-units_min)*pixels_per_unit" units=$monthlyFiveYearStats.sld_avg_sp_to_olp_ratio["avg"] units_min=$monthlyFiveYearStats.sld_avg_sp_to_olp_ratio["min"] pixels_per_unit=$avg_sold_to_olp_ratio_pixels_per_unit}
                 <div class="scale_graduated_trianglebigblue" style="margin-left:{$avg_sold_to_olp_ratio_tbb|number_Format:0}px">{(100.0*$monthlyCurrMonth.sld_avg_sp_to_olp_ratio)|number_format:1:".":","}%<br><img src="img/TriangleBigBlue-26x22.png" width="13" height="11" alt="" /></div>
                 <div class="scale_graduated_trianglesmallteal" style="margin-left:{$avg_sold_to_olp_ratio_tst|number_Format:0}px"><img src="img/TriangleSmallTeal-18x16.png" width="8" height="9" alt="" /><br>{(100.0*$monthlyFiveYearStats.sld_avg_sp_to_olp_ratio["avg"])|number_format:1:".":","}%</div>
               </div><!-- end class=pod-layer2" -->
               <img src="img/ShadowRule-170x8.png" class="shadow-border-low" alt="" />
               <div class="pod-layer3">
                  <div class="prev_month_header">{$prevMonthTimestamp|date_format:"%b %Y"}</div>
                  <div class="prev_year_header">{$prevYearTimestamp|date_format:"%b %Y"}</div>
                  <div class="ytd_year_header">YTD</div>
                  <div class="prev_month_value pod-Strong">&nbsp;{(100.0*$monthlyPrevMonth.sld_avg_sp_to_olp_ratio)|number_format:1:".":","}%</div>
                  <div class="prev_year_value pod-Strong">&nbsp;{(100.0*$monthlyPrevYear.sld_avg_sp_to_olp_ratio)|number_format:1:".":","}%</div>
                  <div class="ytd_year_value pod-Strong">&nbsp;{(100.0*$ytdCurrYear.sld_avg_sp_to_olp_ratio)|number_format:1:".":","}%</div>
               </div><!-- end class=pod-layer3" -->
               </div><!-- end id="pod-Container pod-Text" -->
              </div><!-- end id="avg_sold_to_olp_ratio_section" -->
{/if}

{if isset($average_sold_dollars_per_sqft_section)}
              <div id="{$average_sold_dollars_per_sqft_section}" class="summary">
               <div class="pod-Container pod-Text">
               <div class="pod-layer1">
                <div class="pod-H1">Avg Sold Price<br>per SqFt</div>
                <div class="pod-KeyQuantity">${$monthlyCurrMonth.sld_avg_sp_per_sqft|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer1" -->
               <div class="pod-layer2">
                 <img src="img/ScaleGraduatedGreen-152x10.png" class="scale_graduated" alt="" />
                 <div class="scale_graduated_min">Min<BR>${$monthlyFiveYearStats.sld_avg_sp_per_sqft["min"]|number_format:0:".":","}</div>
                 <div class="scale_graduated_max">Max<BR>${$monthlyFiveYearStats.sld_avg_sp_per_sqft["max"]|number_format:0:".":","}</div>
                 <div class="scale_graduated_subtitle">5-year {$currMonthTimestamp|date_format:"%b"} average</div>
                 {math assign="sld_avg_sp_per_sqft_pixels_per_unit" equation="pixel_width/(units_max-units_min)" pixel_width=152.0 units_max=$monthlyFiveYearStats.sld_avg_sp_per_sqft["max"] units_min=$monthlyFiveYearStats.sld_avg_sp_per_sqft["min"]}
                 {math assign="sld_avg_sp_per_sqft_tbb" equation="(units-units_min)*pixels_per_unit" units=$monthlyCurrMonth.sld_avg_sp_per_sqft units_min=$monthlyFiveYearStats.sld_avg_sp_per_sqft["min"] pixels_per_unit=$sld_avg_sp_per_sqft_pixels_per_unit}
                 {math assign="sld_avg_sp_per_sqft_tst" equation="(units-units_min)*pixels_per_unit" units=$monthlyFiveYearStats.sld_avg_sp_per_sqft["avg"] units_min=$monthlyFiveYearStats.sld_avg_sp_per_sqft["min"] pixels_per_unit=$sld_avg_sp_per_sqft_pixels_per_unit}
                 <div class="scale_graduated_trianglebigblue" style="margin-left:{$sld_avg_sp_per_sqft_tbb|number_Format:0}px">${$monthlyCurrMonth.sld_avg_sp_per_sqft|number_format:0:".":","}<br><img src="img/TriangleBigBlue-26x22.png" width="13" height="11" alt="" /></div>
                 <div class="scale_graduated_trianglesmallteal" style="margin-left:{$sld_avg_sp_per_sqft_tst|number_Format:0}px"><img src="img/TriangleSmallTeal-18x16.png" width="8" height="9" alt="" /><br>${$monthlyFiveYearStats.sld_avg_sp_per_sqft["avg"]|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer2" -->
               <img src="img/ShadowRule-170x8.png" class="shadow-border-low" alt="" />
               <div class="pod-layer3">
                  <div class="prev_month_header">{$prevMonthTimestamp|date_format:"%b %Y"}</div>
                  <div class="prev_year_header">{$prevYearTimestamp|date_format:"%b %Y"}</div>
                  <div class="ytd_year_header">YTD</div>
                  <div class="prev_month_value pod-Strong">&nbsp;${$monthlyPrevMonth.sld_avg_sp_per_sqft|number_format:0:".":","}</div>
                  <div class="prev_year_value pod-Strong">&nbsp;${$monthlyPrevYear.sld_avg_sp_per_sqft|number_format:0:".":","}</div>
                  <div class="ytd_year_value pod-Strong">&nbsp;${$ytdCurrYear.sld_avg_sp_per_sqft|number_format:0:".":","}</div>
               </div><!-- end class=pod-layer3" -->
               </div><!-- end id="pod-Container pod-Text" -->
              </div><!-- end id="average_sold_dollars_per_sqft_section" -->
{/if}

              <div id="footnote">
                  {if $footnote_active!=""}
                    {$footnote_active}
                  {/if}
              </div>
   </div><!-- end id="content" -->

   <div id="footer">
    <div class="footer-bordertop"></div>
    <img src="img/{$mls_logo}" id="footer-image" width="84" height="25" alt="" />
    <div id="footer-source">
            Copyright &copy; {$smarty.now|date_format:'%Y'} RealEstate Business Intelligence, LLC. All Rights Reserved.<br/>
            Data Source: {$mls_name}. Statistics calculated {$gen_date|date_format:"%B %d, %Y"}.
    </div>
   </div><!-- end id="footer" -->

  </div><!-- end id="page" -->
</body>
</html>
