<?php


/**
 * PDFTK -- PHP class to call pdftk binary
 *
 */
class PDFTK {

  /**
  * generate PDF version of the report
  *
  * @param array $formvars the form variables
  */
  function outputCompiledPdf($pdf_files, $filename) {
    $exec_string="";
    foreach ($pdf_files as $pdf) {
        $exec_string .= " " . $pdf;
    }
    if ($exec_string!="") {
        $content = $this->_exec("/usr/bin/pdftk $exec_string cat output -");
        $result=$content["stdout"];
        header("Content-type: application/pdf");
        header("Cache-control: public, must-revalidate, max-age=0");
        header("Pragme: public");
        header("Expires: Sat, 26 Jul 1997 05:00:00 GMT");
        header("Last-Modified: " . gmdate('D, d m Y H:i:s') . " GMT");
        #header("Content-Length " . mb_strlen($result));
        header('Content-Disposition: inline; filename="' . basename($filename) .'";');
        echo $result;
        exit();
    }
  }

  protected function _exec($cmd, $input = "")
    {
        $result = array('stdout' => '', 'stderr' => '', 'return' => '');

        $proc = proc_open($cmd, array(0 => array('pipe', 'r'), 1 => array('pipe', 'w'), 2 => array('pipe', 'w')), $pipes);
        fwrite($pipes[0], $input);
        fclose($pipes[0]);

        $result['stdout'] = stream_get_contents($pipes[1]);
        fclose($pipes[1]);

        $result['stderr'] = stream_get_contents($pipes[2]);
        fclose($pipes[2]);

        $result['return'] = proc_close($proc);

        return $result;
    }

}
