<!DOCTYPE html>
<html class="js" lang="en">
<head>
  <title>QTD Market Statistics - Detailed Report</title>
  <link type="text/css" rel="stylesheet" media="all" href="css/hotfusion.css"/>
   <meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
</head>
<body>
  <div id="page">
    <div id="header">

      <img src="css/market_trends_premium.png" id="logo">
      <img src="css/header_background.jpg" id="header-background">
      <div class="title">
        <div class="location">{$locationName}</div>
        <div class="reportName">QTD Market Statistics - Detailed Report</div>
        <div class="date">{$thisPeriodTimestamp|date_format:"%B %Y"}</div>
      </div>

      <div id="content">
        <div class="module">
          <div class="module_inner">
            <div class="summary_module">

              <div class="sold_summary_section">
              <div class="table_header">Sold Summary</div>
              <table class="data_table">
                <tr>
                  <th class="row_label"></th>
                  <th class="row_data">{$thisPeriodTimestamp|date_format:"%b %Y"}</th>
                  <th class="row_data">{$lastPeriodTimestamp|date_format:"%b %Y"}</th>
                  <th class="row_data">% Change</th>
                </tr>
                <tr>
                  <td class="row_label">Sold Dollar Volume</td>
                  <td class="row_data">${$coreDataThisYear.sld_total_sp|number_format:0:".":","}</td>
                  <td class="row_data">${$coreDataLastYear.sld_total_sp|number_format:0:".":","}</td>
                  <td class="row_data">{$coreDataDiffYear.sld_total_sp|default:'N/A'}</td>
                </tr>
                <tr>
                  <td class="row_label zebra">Avg Sold Price</td>
                  <td class="row_data zebra">${$coreDataThisYear.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data zebra">${$coreDataLastYear.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data zebra">{$coreDataDiffYear.sld_avg_sp|default:'N/A'}</td>
                </tr>
                <tr>
                  <td class="row_label">Median Sold Price</td>
                  <td class="row_data">${$coreDataThisYear.sld_med_sp|number_format:0:".":","}</td>
                  <td class="row_data">${$coreDataLastYear.sld_med_sp|number_format:0:".":","}</td>
                  <td class="row_data">{$coreDataDiffYear.sld_med_sp|default:'N/A'}</td>
                </tr>
                <tr>
                  <td class="row_label zebra">Units Sold</td>
                  <td class="row_data zebra">{$coreDataThisYear.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra">{$coreDataLastYear.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra">{$coreDataDiffYear.num_sold_listings|default:'N/A'}</td>
                </tr>
                <tr>
                  <td class="row_label">Avg Days on Market</td>
                  <td class="row_data">{$coreDataThisYear.sld_avg_dom|number_format:0:".":","}</td>
                  <td class="row_data">{$coreDataLastYear.sld_avg_dom|number_format:0:".":","}</td>
                  <td class="row_data">{$coreDataDiffYear.sld_avg_dom|default:'N/A'}</td>
                </tr>
                <tr>
                  <td class="row_label zebra">Avg List Price for Solds</td>
                  <td class="row_data zebra">${$coreDataThisYear.sld_avg_lp|number_format:0:".":","}</td>
                  <td class="row_data zebra">${$coreDataLastYear.sld_avg_lp|number_format:0:".":","}</td>
                  <td class="row_data zebra">{$coreDataDiffYear.sld_avg_lp|default:'N/A'}</td>
                </tr>
                <tr>
                  <td class="row_label">Avg SP to OLP Ratio</td>
                  <td class="row_data">{($coreDataThisYear.sld_avg_sp_to_olp_ratio*100)|number_format:1:".":","}%</td>
                  <td class="row_data">{($coreDataLastYear.sld_avg_sp_to_olp_ratio*100)|number_format:1:".":","}%</td>
                  <td class="row_data">{$coreDataDiffYear.sld_avg_sp_to_olp_ratio|default:'N/A'}</td>
                </tr>
              </table>
              </div>

              <div class="notes_section">
                 <div>Notes:</div>
                 <ul>
                   <li>SP = Sold Price</li>
                   <li>OLP = Original List Price</li>
                 </ul>
              </div>

<!--
            <div class="financing_section yearly">
              <div class="table_header">Financing (Sold)</div>
              <table class="data_table">
                <tr>
                  <td class="row_label">Cash</td>
                  <td class="row_data">{$financingDataThisYear.fid1091.num_sold_listings|number_format:0:".":","}</td>
                </tr>
                <tr>
                  <td class="row_label zebra">Conventional</td>
                  <td class="row_data zebra">{$financingDataThisYear.fid1092.num_sold_listings|number_format:0:".":","}</td>
                </tr>
                <tr>
                  <td class="row_label">FHA</td>
                  <td class="row_data">{$financingDataThisYear.fid1093.num_sold_listings|number_format:0:".":","}</td>
                </tr>
                <tr>
                  <td class="row_label zebra">Other</td>
                  <td class="row_data zebra">{$financingDataThisYear.fid1096.num_sold_listings|number_format:0:".":","}</td>
                </tr>
                <tr>
                  <td class="row_label">Owner</td>
                  <td class="row_data">{$financingDataThisYear.fid1095.num_sold_listings|number_format:0:".":","}</td>
                </tr>
                <tr>
                  <td class="row_label zebra">VA</td>
                  <td class="row_data zebra">{$financingDataThisYear.fid1094.num_sold_listings|number_format:0:".":","}</td>
                </tr>
              </table>
              </div>
-->

             <div class="dom_section yearly">
              <div class="table_header">{$domSectionLabel}</div>
              <table class="data_table">
                {assign var="even" value=false}
                {foreach from=$domFacetList item=domFacet}
                {assign var="domData" value=$domDataThisYear["fid"|cat:$domFacet.f_id]}
                <tr>
                  <td class="row_label {if $even}zebra{/if}">{$domFacet.f_desc|replace:' Days':''}</td>
                  <td class="row_data {if $even}zebra{/if}">{$domData.num_sold_listings|number_format:0:".":","}</td>
                </tr>
                {assign var="even" value=!$even}
               {/foreach}
              </table>
              </div>

              <div class="active_detail_section yearly">
              <div class="table_header">Active Detail</div>
              </div>

              <div class="sold_detail_section yearly">
              <div class="table_header">Sold Detail</div>
              <table class="data_table">
                <tr>
                  <th class="row_label">Price Ranges</th>
                  <th class="row_data" colspan="1">2 or Less BR</th>
                  <th class="row_data" colspan="1">3 BR</th>
                  <th class="row_data" colspan="1">4 or More BR</th>
                  <th class="row_data right_border_big">Total</th>
                  <th class="row_data" colspan="1">2 or Less BR</th>
                  <th class="row_data" colspan="1">3 BR</th>
                  <th class="row_data" colspan="1">4 or More BR</th>
                  <th class="row_data">Total</th>
                </tr>
                {assign var="even" value=false}
                {foreach from=$spFacetList item=spFacet}
                {assign var="lpFacetId" value=$spFacet.f_id-13}
                {assign var="spBrData" value=$brDetailDataThisYear["fid"|cat:$spFacet.f_id]}
                {assign var="spAllData" value=$allSoldDetailDataThisYear["fid"|cat:$spFacet.f_id]}
                {assign var="lpAllData" value=$allListDetailDataThisYear["fid"|cat:$lpFacetId]}
                {assign var="lpBrData" value=$brListDetailDataThisYear["fid"|cat:$lpFacetId]}
                {assign var="spCoreData" value=$spCoreDataThisYear["fid"|cat:$spFacet.f_id]}
                {assign var="lpCoreData" value=$lpCoreDataThisYear["fid"|cat:$lpFacetId]}
                <tr>
                  <td class="row_label {if $even}zebra{/if}">{$spFacet.f_desc}</td>
                  <td class="row_data {if $even}zebra{/if}">{$spBrData.fid1000.fid1097.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data {if $even}zebra{/if}">{$spBrData.fid1000.fid1098.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data {if $even}zebra{/if}">{$spBrData.fid1000.fid1099.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data {if $even}zebra{/if} right_border_big">{$spCoreData.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data {if $even}zebra{/if}">{$lpBrData.fid1000.fid1097.num_active_listings|number_format:0:".":","}</td>
                  <td class="row_data {if $even}zebra{/if}">{$lpBrData.fid1000.fid1098.num_active_listings|number_format:0:".":","}</td>
                  <td class="row_data {if $even}zebra{/if}">{$lpBrData.fid1000.fid1099.num_active_listings|number_format:0:".":","}</td>
                  <td class="row_data {if $even}zebra{/if}">{$lpCoreData.num_active_listings|number_format:0:".":","}</td>
                </tr>
                {assign var="even" value=!$even}
                {/foreach}
               <tr>
                  <td class="row_label zebra top_border_big">Total</td>
                  <td class="row_data zebra top_border_big">{$brCoreDataThisYear.fid1097.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra top_border_big">{$brCoreDataThisYear.fid1098.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra top_border_big">{$brCoreDataThisYear.fid1099.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra top_border_big right_border_big">{$coreDataThisYear.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra top_border_big">{$brCoreDataThisYear.fid1097.num_active_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra top_border_big">{$brCoreDataThisYear.fid1098.num_active_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra top_border_big">{$brCoreDataThisYear.fid1099.num_active_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra top_border_big">{$coreDataThisYear.num_active_listings|number_format:0:".":","}</td>
                </tr>
               <tr>
                  <td class="row_label">Avg Sold Price</td>
                  <td class="row_data">${$brCoreDataThisYear.fid1097.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data">${$brCoreDataThisYear.fid1098.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data">${$brCoreDataThisYear.fid1098.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data right_border_big">${$coreDataThisYear.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data no_border"></td>
                  <td class="row_data no_border"></td>
                  <td class="row_data no_border"></td>
                  <td class="row_data no_border"></td>
                </tr>
               <tr>
                  <td class="row_label zebra">Prev Year - Avg Sold Price</td>
                  <td class="row_data zebra">${$brCoreDataLastYear.fid1097.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data zebra">${$brCoreDataLastYear.fid1098.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data zebra">${$brCoreDataLastYear.fid1098.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data zebra right_border_big">${$coreDataLastYear.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data no_border"></td>
                  <td class="row_data no_border"></td>
                  <td class="row_data no_border"></td>
                  <td class="row_data no_border"></td>
                </tr>
               <tr>
                  <td class="row_label">Avg Sold % Change</td>
                  <td class="row_data">{$brCoreDataDiffYear.fid1097.sld_avg_sp|number_format:2:".":","}%</td>
                  <td class="row_data">{$brCoreDataDiffYear.fid1098.sld_avg_sp|number_format:2:".":","}%</td>
                  <td class="row_data">{$brCoreDataDiffYear.fid1099.sld_avg_sp|number_format:2:".":","}%</td>
                  <td class="row_data right_border_big">{$coreDataDiffYear.sld_avg_sp|number_format:2:".":","}%</td>
                  <td class="row_data no_border"></td>
                  <td class="row_data no_border"></td>
                  <td class="row_data no_border"></td>
                  <td class="row_data no_border"></td>
                </tr>
               <tr>
                  <td class="row_label zebra">Prev Year - # of Solds</td>
                  <td class="row_data zebra">{$brCoreDataLastYear.fid1097.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra">{$brCoreDataLastYear.fid1098.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra">{$brCoreDataLastYear.fid1099.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra right_border_big">{$coreDataLastYear.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data no_border"></td>
                  <td class="row_data no_border"></td>
                  <td class="row_data no_border"></td>
                  <td class="row_data no_border"></td>
                </tr>
              </table>
              </div>
            </div><!-- end id="summary_module" -->
            </div><!-- end id="module" -->

            <img src="css/report_footer.jpg" id="footer_image">
            <div id="footer">
              All data provided by CoreLogic. This report may be reproduced by CoreLogic members. Generated on {$coreDataThisYear.last_update_tms|date_format:"%m/%d/%Y"}.<br/>Powered by RealEstate Business Intelligence, LLC. <br/>
              Copyright {$smarty.now|date_format:'%Y'} - All Rights Reserved. Information deemed reliable, but is not guaranteed.
            </div>

          </div><!-- end id="module_inner" -->
        </div><!-- end id="content" -->
      </div><!-- end id="header" -->
    </div>
  </div>
</body>
</html>
