<?php

class Config
{
    // set the $mls_name for a given MLS and the rest of the config will get set in the
    // switch statement lower down
    public $mls_name = 'CoreLogic';

    public $mls_logo;
    public $locations;
    public $user_data_url;

    /* default database settings */
    public $dbtype = 'mysql';
    public $dbname = 'aggdata';
    public $dbhost = 'localhost';
    public $dbuser = 'reports';
    public $dbpass = '';

    /* other defaults */
    public $show_logo_on_cover = false;
    public $show_dom_widget = true;
    public $chart_bar_label = "Closed Sales";
    public $footnote_active = "";
    public $footnote_standard = "";

    function __construct()
    {
        switch ($this->mls_name) {
            case "ARMLS":
                $this->mls_logo = 'ARMLS-logo-165x64.png';
                $this->show_logo_on_cover = true;
                $this->locations = array(1, 2, 4, 6);
                $this->dbname = 'ARMLS_aggdata_patch';
                $this->user_data_url = "http://www.armls.rbintel.com/userinfo/?user=";
                $this->chart_bar_label = "New Contracts";
                $this->footnote_active = "&bull; When calculating the Contract Ratio, the number of Contracts (Pending and AWC) are divided by the number of Active listings";
                break;
            case "CAAR":
                $this->mls_logo = 'CAAR-logo-218x100.jpg';
                $this->locations = array(1, 2, 4);
                $this->dbname = 'CAAR_aggdata';
                break;
            case "CVRMLS":
                $this->mls_logo = 'CVRMLS-logo-250x100.png';
                $this->locations = array(1, 2, 4);
                $this->dbname = 'CVRMLS_aggdata';
                $this->show_dom_widget = false;
                break;
            case "MFRMLS":
                $this->mls_logo = 'MFRMLS-logo-167x100.jpg';
                $this->locations = array(1, 2, 3, 4);
                $this->dbname = 'MFRMLS_aggdata';
                break;
            case "MRIS":
                $this->mls_logo = 'rbi-logo-166x50.jpg';
                $this->locations = array(1, 2, 3, 4);
                $this->dbname = 'aggdata';
                break;
            case "CoreLogic":
                #$this->mls_logo = 'Innovia-logo-215x105.png';
                #$this->mls_logo = 'core_logic_logo.png';
                $this->mls_logo = 'market_trends_premium.png';
                $this->locations = array(1, 4, 6);
                #$this->dbname = 'CLLIS_aggdata';
                $this->dbname = 'MLS_217_AGG';
                $this->user_data_url = "http://www.marketrendspremium.com/userinfo/test.php?user=";
                break;
        }
    }

}
