<!DOCTYPE html>
<html class="js" lang="en">
<head>
  <title>Yearly Market Statistics – Detailed Report</title>
  <link type="text/css" rel="stylesheet" media="all" href="css/hotfusion.css"/>
</head>
<body>
  <div id="page">
    <div id="header">

      <img src="css/report_header.jpg" id="logo">
      <div class="title">
        <div class="location">{$locationName}</div>
        <div class="reportName">Year End Market Statistics - Detailed Report</div>
        <div class="date">{$thisPeriodTimestamp|date_format:"%Y"}</div>
      </div>

      <div id="content">
        <div class="module">
          <div class="module_inner">
            <div class="summary_module">

              <div class="sold_summary_section">
              <div class="table_header">Sold Summary</div>
              <table class="data_table">
                <tr>
                  <th class="row_label"></th>
                  <th class="row_data">{$thisPeriodTimestamp|date_format:"%Y"}</th>
                  <th class="row_data">{$lastPeriodTimestamp|date_format:"%Y"}</th>
                  <th class="row_data">% Change</th>
                </tr>
                <tr>
                  <td class="row_label">Sold Dollar Volume</td>
                  <td class="row_data">${$coreDataThisYear.sld_total_sp|number_format:0:".":","}</td>
                  <td class="row_data">${$coreDataLastYear.sld_total_sp|number_format:0:".":","}</td>
                  <td class="row_data">{$coreDataDiffYear.sld_total_sp}%</td>
                </tr>
                <tr>
                  <td class="row_label zebra">Avg Sold Price</td>
                  <td class="row_data zebra">${$coreDataThisYear.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data zebra">${$coreDataLastYear.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data zebra">{$coreDataDiffYear.sld_avg_sp}%</td>
                </tr>
                <tr>
                  <td class="row_label">Median Sold Price</td>
                  <td class="row_data">${$coreDataThisYear.sld_med_sp|number_format:0:".":","}</td>
                  <td class="row_data">${$coreDataLastYear.sld_med_sp|number_format:0:".":","}</td>
                  <td class="row_data">{$coreDataDiffYear.sld_med_sp}%</td>
                </tr>
                <tr>
                  <td class="row_label zebra">Units Sold</td>
                  <td class="row_data zebra">{$coreDataThisYear.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra">{$coreDataLastYear.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra">{$coreDataDiffYear.num_sold_listings}%</td>
                </tr>
                <tr>
                  <td class="row_label">Avg Days on Market</td>
                  <td class="row_data">{$coreDataThisYear.sld_avg_dom|number_format:0:".":","}</td>
                  <td class="row_data">{$coreDataLastYear.sld_avg_dom|number_format:0:".":","}</td>
                  <td class="row_data">{$coreDataDiffYear.sld_avg_dom}%</td>
                </tr>
                <tr>
                  <td class="row_label zebra">Avg List Price for Solds</td>
                  <td class="row_data zebra">${$coreDataThisYear.sld_avg_lp|number_format:0:".":","}</td>
                  <td class="row_data zebra">${$coreDataLastYear.sld_avg_lp|number_format:0:".":","}</td>
                  <td class="row_data zebra">{$coreDataDiffYear.sld_avg_lp}%</td>
                </tr>
                <tr>
                  <td class="row_label">Avg SP to OLP Ratio</td>
                  <td class="row_data">{($coreDataThisYear.sld_avg_sp_to_olp_ratio*100)|number_format:1:".":","}%</td>
                  <td class="row_data">{($coreDataLastYear.sld_avg_sp_to_olp_ratio*100)|number_format:1:".":","}%</td>
                  <td class="row_data">{$coreDataDiffYear.sld_avg_sp_to_olp_ratio}%</td>
                </tr>
                <tr>
                  <td class="row_label zebra">Ratio of Avg SP to Avg OLP</td>
                  <td class="row_data zebra">{($coreDataThisYear.sld_avg_sp_to_avg_olp_ratio*100)|number_format:1:".":","}%</td>
                  <td class="row_data zebra">{($coreDataLastYear.sld_avg_sp_to_avg_olp_ratio*100)|number_format:1:".":","}%</td>
                  <td class="row_data zebra">{$coreDataDiffYear.sld_avg_sp_to_avg_olp_ratio}%</td>
                </tr>
                <tr>
                  <td class="row_label">Attached Avg Sold Price</td>
                  <td class="row_data">${$attachedDataThisYear.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data">${$attachedDataLastYear.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data">{$attachedDataDiffYear.sld_avg_sp}%</td>
                </tr>
                <tr>
                  <td class="row_label zebra">Detached Avg Sold Price</td>
                  <td class="row_data zebra">${$detachedDataThisYear.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data zebra">${$detachedDataLastYear.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data zebra">{$detachedDataDiffYear.sld_avg_sp}%</td>
                </tr>
                <tr>
                  <td class="row_label">Attached Units Sold</td>
                  <td class="row_data">{$attachedDataThisYear.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data">{$attachedDataLastYear.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data">{$attachedDataDiffYear.num_sold_listings}%</td>
                </tr>
                <tr>
                  <td class="row_label zebra">Detached Units Sold</td>
                  <td class="row_data zebra">{$detachedDataThisYear.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra">{$detachedDataLastYear.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra">{$detachedDataDiffYear.num_sold_listings}%</td>
                </tr>
              </table>
              </div>

              <div class="notes_section">
                 <div>Notes:</div>
                 <ul>
                   <li>SP = Sold Price</li>
                   <li>OLP = Original List Price</li>
                   <li>LP = List Price (at time of sale)</li>
                   <li>Garage/Parking Spaces are not included in Detached/Attached section totals.</li>
                 </ul>
              </div>

            <div class="financing_section yearly">
              <div class="table_header">Financing (Sold)</div>
              <table class="data_table">
                <tr>
                  <td class="row_label">Assumption</td>
                  <td class="row_data">{$financingDataThisYear.fid1090.num_sold_listings|number_format:0:".":","}</td>
                </tr>
                <tr>
                  <td class="row_label zebra">Cash</td>
                  <td class="row_data zebra">{$financingDataThisYear.fid1091.num_sold_listings|number_format:0:".":","}</td>
                </tr>
                <tr>
                  <td class="row_label">Conventional</td>
                  <td class="row_data">{$financingDataThisYear.fid1092.num_sold_listings|number_format:0:".":","}</td>
                </tr>
                <tr>
                  <td class="row_label zebra">FHA</td>
                  <td class="row_data zebra">{$financingDataThisYear.fid1093.num_sold_listings|number_format:0:".":","}</td>
                </tr>
                <tr>
                  <td class="row_label">Other</td>
                  <td class="row_data">{$financingDataThisYear.fid1096.num_sold_listings|number_format:0:".":","}</td>
                </tr>
                <tr>
                  <td class="row_label zebra">Owner</td>
                  <td class="row_data zebra">{$financingDataThisYear.fid1095.num_sold_listings|number_format:0:".":","}</td>
                </tr>
                <tr>
                  <td class="row_label">VA</td>
                  <td class="row_data">{$financingDataThisYear.fid1094.num_sold_listings|number_format:0:".":","}</td>
                </tr>
              </table>
              </div>

             <div class="dom_section yearly">
              <div class="table_header">Days on Market (Sold)</div>
              <table class="data_table">
                {assign var="even" value=false}
                {foreach from=$domFacetList item=domFacet}
                {assign var="domData" value=$domDataThisYear["fid"|cat:$domFacet.f_id]}
                <tr>
                  <td class="row_label {if $even}zebra{/if}">{$domFacet.f_desc|replace:' Days':''}</td>
                  <td class="row_data {if $even}zebra{/if}">{$domData.num_sold_listings|number_format:0:".":","}</td>
                </tr>
                {assign var="even" value=!$even}
               {/foreach}
              </table>
              </div>

              <div class="sold_detail_section yearly">
              <div class="table_header">Sold Detail</div>
              <table class="data_table">
                <tr>
                  <th class="row_label" rowspan=2></th>
                  <th class="row_data" colspan="6">Residential</th>
                  <th class="row_data left_border_med" colspan="1">Condo/Coop</th>
                </tr>
                <tr>
                  <th class="row_data" colspan="2">2 or Less BR</th>
                  <th class="row_data left_border_med" colspan="2">3 BR</th>
                  <th class="row_data left_border_med" colspan="2">4 or More BR</th>
                  <th class="row_data left_border_med" colspan="1">All</th>
                </tr>
                <tr>
                  <th class="row_label">Price Ranges</th>
                  <th class="row_data">Detached</th>
                  <th class="row_data">Attached/TH</th>
                  <th class="row_data left_border_med">Detached</th>
                  <th class="row_data">Attached/TH</th>
                  <th class="row_data left_border_med">Detached</th>
                  <th class="row_data">Attached/TH</th>
                  <th class="row_data left_border_med">Attached</th>
                </tr>
                {assign var="even" value=false}
                {foreach from=$spFacetList item=spFacet}
                {assign var="lpFacetId" value=$spFacet.f_id-13}
                {assign var="spBrData" value=$brDetailDataThisYear["fid"|cat:$spFacet.f_id]}
                {assign var="spAllData" value=$allSoldDetailDataThisYear["fid"|cat:$spFacet.f_id]}
                <tr>
                  <td class="row_label {if $even}zebra{/if}">{$spFacet.f_desc}</td>
                  <td class="row_data {if $even}zebra{/if}">{$spBrData.fid1001.fid1097.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data {if $even}zebra{/if}">{$spBrData.fid1004.fid1097.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data {if $even}zebra{/if} left_border_med">{$spBrData.fid1001.fid1098.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data {if $even}zebra{/if}">{$spBrData.fid1004.fid1098.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data {if $even}zebra{/if} left_border_med">{$spBrData.fid1001.fid1099.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data {if $even}zebra{/if}">{$spBrData.fid1004.fid1099.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data {if $even}zebra{/if} left_border_med">{$spAllData.fid1005.fid1000.num_sold_listings|number_format:0:".":","}</td>
                </tr>
                {assign var="even" value=!$even}
                {/foreach}
               <tr>
                  <td class="row_label zebra top_border_big">Total</td>
                  <td class="row_data zebra top_border_big">{$tbrDetailDataThisYear.fid1000.fid1001.fid1097.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra top_border_big">{$tbrDetailDataThisYear.fid1000.fid1004.fid1097.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra top_border_big left_border_med">{$tbrDetailDataThisYear.fid1000.fid1001.fid1098.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra top_border_big">{$tbrDetailDataThisYear.fid1000.fid1004.fid1098.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra top_border_big left_border_med">{$tbrDetailDataThisYear.fid1000.fid1001.fid1099.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra top_border_big">{$tbrDetailDataThisYear.fid1000.fid1004.fid1099.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra top_border_big left_border_med">{$tallCoreDataThisYear.fid1005.num_sold_listings|number_format:0:".":","}</td>
                </tr>
               <tr>
                  <td class="row_label">Avg Sold Price</td>
                  <td class="row_data">${$tbrDetailDataThisYear.fid1000.fid1001.fid1097.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data">${$tbrDetailDataThisYear.fid1000.fid1004.fid1097.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data left_border_med">${$tbrDetailDataThisYear.fid1000.fid1001.fid1098.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data">${$tbrDetailDataThisYear.fid1000.fid1004.fid1098.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data left_border_med">${$tbrDetailDataThisYear.fid1000.fid1001.fid1099.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data">${$tbrDetailDataThisYear.fid1000.fid1004.fid1099.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data left_border_med">${$tallCoreDataThisYear.fid1005.sld_avg_sp|number_format:0:".":","}</td>
                </tr>
               <tr>
                  <td class="row_label zebra">Prev Year - Avg Sold Price</td>
                  <td class="row_data zebra">${$tbrDetailDataLastYear.fid1000.fid1001.fid1097.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data zebra">${$tbrDetailDataLastYear.fid1000.fid1004.fid1097.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data zebra left_border_med">${$tbrDetailDataLastYear.fid1000.fid1001.fid1098.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data zebra">${$tbrDetailDataLastYear.fid1000.fid1004.fid1098.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data zebra left_border_med">${$tbrDetailDataLastYear.fid1000.fid1001.fid1099.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data zebra">${$tbrDetailDataLastYear.fid1000.fid1004.fid1099.sld_avg_sp|number_format:0:".":","}</td>
                  <td class="row_data zebra left_border_med">${$tallCoreDataLastYear.fid1005.sld_avg_sp|number_format:0:".":","}</td>
                </tr>
               <tr>
                  <td class="row_label">Avg Sold % Change</td>
                  <td class="row_data">{$tbrDetailDataDiffYear.fid1000.fid1001.fid1097.sld_avg_sp|number_format:2:".":","}%</td>
                  <td class="row_data">{$tbrDetailDataDiffYear.fid1000.fid1004.fid1097.sld_avg_sp|number_format:2:".":","}%</td>
                  <td class="row_data left_border_med">{$tbrDetailDataDiffYear.fid1000.fid1001.fid1098.sld_avg_sp|number_format:2:".":","}%</td>
                  <td class="row_data">{$tbrDetailDataDiffYear.fid1000.fid1004.fid1098.sld_avg_sp|number_format:2:".":","}%</td>
                  <td class="row_data left_border_med">{$tbrDetailDataDiffYear.fid1000.fid1001.fid1099.sld_avg_sp|number_format:2:".":","}%</td>
                  <td class="row_data">{$tbrDetailDataDiffYear.fid1000.fid1004.fid1099.sld_avg_sp|number_format:2:".":","}%</td>
                  <td class="row_data left_border_med">{$tallCoreDataDiffYear.fid1005.sld_avg_sp|number_format:2:".":","}%</td>
                </tr>
               <tr>
                  <td class="row_label zebra">Prev Year - # of Solds</td>
                  <td class="row_data zebra">{$tbrDetailDataLastYear.fid1000.fid1001.fid1097.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra">{$tbrDetailDataLastYear.fid1000.fid1004.fid1097.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra left_border_med">{$tbrDetailDataLastYear.fid1000.fid1001.fid1098.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra">{$tbrDetailDataLastYear.fid1000.fid1004.fid1098.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra left_border_med">{$tbrDetailDataLastYear.fid1000.fid1001.fid1099.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra">{$tbrDetailDataLastYear.fid1000.fid1004.fid1099.num_sold_listings|number_format:0:".":","}</td>
                  <td class="row_data zebra left_border_med">{$tallCoreDataLastYear.fid1005.num_sold_listings|number_format:0:".":","}</td>
                </tr>
              </table>
              </div>
            </div><!-- end id="summary_module" -->
            </div><!-- end id="module" -->

            <img src="css/report_footer.jpg" id="footer_image">
            <div id="footer">
              Source: RealEstate Business Intelligence, LLC. An MRIS company. Statistics generated on {$coreDataThisYear.last_update_tms|date_format:"%m/%d/%Y"}.<br/>
              Copyright 2011 - All Rights Reserved. Information deemed reliable, but is not guaranteed.
            </div>

          </div><!-- end id="module_inner" -->
        </div><!-- end id="content" -->
      </div><!-- end id="header" -->
    </div>
  </div>
</body>
</html>
