<?php

/**
 * Project: RBI PDF Reporting Engine
 * Author: Grant McClure
 * File: index.php
 * Version: 1.0
 */

define('RBI_REPORT_DIR', realpath('.') . "/");
define('SMARTY_DIR', RBI_REPORT_DIR . 'Smarty-3.0.6/libs/');
// include the setup script
include(RBI_REPORT_DIR . 'libs/rbi_report_setup.php');

// create rbiReport object
$rbiReport = new RBI_Report();

// set the current action
if (isset($_SERVER['argv']) && (count($_SERVER['argv'])>= 2)) {
  $action = $_SERVER['argv'][1];
  $loc_type = $_SERVER['argv'][2];
  $loc_id = $_SERVER['argv'][3];
  $time_period = $_SERVER['argv'][4];
} elseif (isset($_REQUEST['action'])) {
  $action = $_REQUEST['action'];
  $agg_type = $_REQUEST['agg_type'];
  $loc_type = $_REQUEST['loc_type'];
  $loc_id = $_REQUEST['loc_id'];
  $time_period = $_REQUEST['time_period'];
} else {
  $action = 'html';
  $agg_type = 'YEARLY';
  $loc_type = 4;
  $loc_id = 51510;
  $loc_id = 24031;
  //$loc_id = 24510;
  //$loc_id = 24043;
  $time_period = 2009;
}

if (!(isset($loc_type))) {
  echo "Argument 'loc_type' must have a value";
  exit;
}
if (!(isset($loc_id))) {
  echo "Argument 'loc_id' must have a value";
  exit;
}
if (!(isset($time_period))) {
  echo "Argument 'time_period' must have a value";
  exit;
}

$locationTypes = $rbiReport->getLocationTypes();
$lt_desc=$locationTypes[$loc_type-1]["lt_desc"];
$location = $rbiReport->getLocationData($loc_type, $loc_id);
$loc_id=$location["l_id"];
$l_desc=$location["l_desc"];
$l_sdesc=$location["l_shortname"];
if ($l_sdesc!="") {
  $l_desc = strtoupper($l_sdesc);
}

$reportDir = RBI_REPORT_DIR . "reports/$time_period/";
if (!(file_exists($reportDir))) {
  mkdir($reportDir,0777);
}

if (strlen($time_period)==6) {
  $title = "Monthly Market Statistics – Detailed Report";
} else if (strlen($time_period)==4) {
  $title = "Yearly Market Statistics – Detailed Report";
}

$filename = $lt_desc . "-" . $l_desc . "-" . $time_period;
$filename = preg_replace("/[^A-Za-z0-9-.]/", "", $filename) . ".pdf";
$filepath = $reportDir . $filename;

switch($action) {
    case 'pdf':
        // submitting a rbiReport entry
        //$rbiReport->outputPdfReport($loc_type, $loc_id, $time_period, $filepath, $title);
        $rbiReport->outputPdfReport($agg_type, $loc_type, $loc_id, $time_period, $filename, $title);
        break;
    case 'html':
    default:
        // viewing the rbiReport
        $rbiReport->outputHtmlReport($agg_type, $loc_type, $loc_id, $time_period);
        break;   
}

?>
